/*:
 * @plugindesc Custom Fade Color Plugin
 * @target MZ
 * @help
 * This plugin changes the fade in and fade out colors.
 * Use the following script calls to change the fade color to white:
 *
 * FadeOutWhite
 * FadeInWhite
 */

(function() {
    const _Scene_Base_startFadeOut = Scene_Base.prototype.startFadeOut;
    Scene_Base.prototype.startFadeOut = function(duration, white) {
        const color = white ? [255, 255, 255] : [0, 0, 0];
        this.createFadeSprite(color);
        _Scene_Base_startFadeOut.call(this, duration, white);
    };

    const _Scene_Base_startFadeIn = Scene_Base.prototype.startFadeIn;
    Scene_Base.prototype.startFadeIn = function(duration, white) {
        const color = white ? [255, 255, 255] : [0, 0, 0];
        this.createFadeSprite(color);
        _Scene_Base_startFadeIn.call(this, duration, white);
    };

    Scene_Base.prototype.createFadeSprite = function(color) {
        if (!this._fadeSprite) {
            this._fadeSprite = new ScreenSprite();
            this.addChild(this._fadeSprite);
        }
        this._fadeSprite.setColor(color[0], color[1], color[2]);
    };

    window.FadeOutWhite = function(duration = 60) {
        SceneManager._scene.startFadeOut(duration, true);
    };

    window.FadeInWhite = function(duration = 60) {
        SceneManager._scene.startFadeIn(duration, true);
    };
})();